<?php session_start(); require_once 'config.php'; ?>
<!doctype html>
<html class="no-js" lang="zxx">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Blog Details - Cleaning Service</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="https://fonts.googleapis.com/css2?family=Fuzzy+Bubbles:wght@400;700&family=Poppins:wght@400;500;600;700;800&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        :root {
            --theme-color: #109C3D;
            --secondary-color: #042A2F;
            --title-color: #063A41;
            --text-color: #5E5C78;
            --light-color: #f1f5f4;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #f1f5f4 0%, #ffffff 100%);
            min-height: 100vh;
        }

        /* ===== BLOG DETAILS WRAPPER ===== */
        .blog-details-wrapper {
            padding: clamp(20px, 5vw, 40px) 0;
        }

        /* ===== FEATURED IMAGE WITH ANIMATION ===== */
        .blog-featured-image-wrapper {
            position: relative;
            margin-bottom: clamp(30px, 4vw, 50px);
            border-radius: 16px;
            overflow: hidden;
            background: white;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.5);
        }

        .blog-featured-image {
            width: 100%;
            max-height: 500px;
            object-fit: cover;
            display: block;
            transition: transform 0.5s ease;
        }

        .blog-featured-image-wrapper:hover .blog-featured-image {
            transform: scale(1.03);
        }

        /* ===== HEADER SECTION WITH GLASSMORPHISM ===== */
        .blog-post-header {
            margin-bottom: clamp(30px, 4vw, 50px);
            padding: clamp(20px, 3vw, 40px);
            background: rgba(255, 255, 255, 0.7);
            border-radius: 16px;
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.8);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
        }

        .blog-post-header:hover {
            background: rgba(255, 255, 255, 0.9);
            box-shadow: 0 12px 48px rgba(0, 0, 0, 0.12);
        }

        .blog-post-header h1 {
            font-size: clamp(24px, 4vw, 48px);
            font-weight: 800;
            margin-bottom: clamp(15px, 2vw, 25px);
            color: #063A41;
            line-height: 1.2;
            background: linear-gradient(135deg, #063A41 0%, #109C3D 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* ===== BLOG META ===== */
        .blog-meta {
            display: flex;
            flex-wrap: wrap;
            gap: clamp(12px, 2.5vw, 25px);
            margin-bottom: clamp(15px, 2vw, 25px);
            font-size: clamp(13px, 2vw, 15px);
        }

        .blog-meta span {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 8px 16px;
            background: rgba(16, 156, 61, 0.1);
            border-radius: 8px;
            color: #063A41;
            border: 1px solid rgba(16, 156, 61, 0.2);
            transition: all 0.3s ease;
        }

        .blog-meta span:hover {
            background: rgba(16, 156, 61, 0.15);
            transform: translateY(-2px);
        }

        .blog-meta i {
            color: #109C3D;
            font-size: clamp(13px, 2vw, 16px);
        }

        /* ===== BLOG CONTENT ===== */
        .blog-post-content {
            font-size: clamp(15px, 2vw, 17px);
            line-height: 1.8;
            color: #555;
            background: rgba(255, 255, 255, 0.6);
            border-radius: 16px;
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.7);
            padding: clamp(25px, 3vw, 40px);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.05);
            margin-bottom: clamp(25px, 3vw, 40px);
        }

        .blog-post-content h2,
        .blog-post-content h3 {
            font-size: clamp(20px, 3.5vw, 32px);
            font-weight: 700;
            color: #063A41;
            margin: clamp(30px, 4vw, 50px) 0 clamp(15px, 2vw, 25px);
            position: relative;
            padding-left: 20px;
        }

        .blog-post-content h2:before,
        .blog-post-content h3:before {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: clamp(20px, 3vw, 30px);
            background: linear-gradient(135deg, #109C3D 0%, #067839 100%);
            border-radius: 4px;
        }

        .blog-post-content p {
            margin-bottom: clamp(15px, 2vw, 25px);
            text-align: justify;
        }

        .blog-post-content ul,
        .blog-post-content ol {
            margin-left: clamp(20px, 3vw, 40px);
            margin-bottom: clamp(15px, 2vw, 25px);
        }

        .blog-post-content li {
            margin-bottom: clamp(12px, 1.5vw, 18px);
        }

        .blog-post-content li:before {
            content: '✓';
            color: #109C3D;
            font-weight: bold;
            margin-right: 10px;
        }

        /* ===== SIDEBAR WIDGET WITH GLASSMORPHISM ===== */
        .sidebar-widget {
            background: rgba(255, 255, 255, 0.7);
            border-radius: 16px;
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.8);
            padding: clamp(25px, 3vw, 35px);
            margin-bottom: clamp(25px, 3vw, 35px);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
        }

        .sidebar-widget:hover {
            background: rgba(255, 255, 255, 0.9);
            box-shadow: 0 12px 48px rgba(0, 0, 0, 0.12);
            transform: translateY(-4px);
        }

        .sidebar-widget h3 {
            font-size: clamp(18px, 2.5vw, 22px);
            font-weight: 700;
            color: #063A41;
            margin-bottom: clamp(20px, 2.5vw, 25px);
            padding-bottom: clamp(15px, 2vw, 20px);
            border-bottom: 2px solid transparent;
            background: linear-gradient(to right, #109C3D, #042A2F);
            background-position: left bottom;
            background-repeat: no-repeat;
            background-size: 50px 2px;
        }

        .sidebar-widget ul {
            list-style: none;
            padding: 0;
        }

        .sidebar-widget li {
            margin-bottom: clamp(12px, 1.5vw, 16px);
            padding: clamp(8px, 1vw, 12px) clamp(12px, 1.5vw, 16px);
            background: rgba(16, 156, 61, 0.05);
            border-left: 3px solid #109C3D;
            border-radius: 6px;
            transition: all 0.3s ease;
        }

        .sidebar-widget li:hover {
            background: rgba(16, 156, 61, 0.1);
            transform: translateX(8px);
        }

        .sidebar-widget a {
            color: #063A41;
            text-decoration: none;
            font-size: clamp(13px, 2vw, 15px);
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .sidebar-widget a:hover {
            color: #109C3D;
        }

        /* ===== AUTHOR CARD ===== */
        .author-card {
            background: linear-gradient(135deg, rgba(16, 156, 61, 0.1) 0%, rgba(4, 42, 47, 0.05) 100%);
            border-radius: 16px;
            backdrop-filter: blur(20px);
            border: 1px solid rgba(16, 156, 61, 0.2);
            padding: clamp(25px, 3vw, 35px);
            margin-top: clamp(30px, 4vw, 50px);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.05);
            text-align: center;
        }

        .author-card h4 {
            font-size: clamp(16px, 2.5vw, 20px);
            color: #063A41;
            margin-bottom: 8px;
        }

        .author-card p {
            color: #666;
            font-size: clamp(13px, 2vw, 15px);
        }

        /* ===== SHARE BUTTONS ===== */
        .share-buttons {
            display: flex;
            gap: clamp(10px, 2vw, 15px);
            flex-wrap: wrap;
            margin-top: clamp(20px, 3vw, 30px);
        }

        .share-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: clamp(40px, 6vw, 48px);
            height: clamp(40px, 6vw, 48px);
            border-radius: 50%;
            background: rgba(16, 156, 61, 0.1);
            border: 1px solid rgba(16, 156, 61, 0.3);
            color: #109C3D;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: clamp(16px, 2vw, 18px);
        }

        .share-btn:hover {
            background: #109C3D;
            color: white;
            transform: translateY(-4px);
            box-shadow: 0 8px 20px rgba(16, 156, 61, 0.4);
        }

        /* ===== LOADING STATE ===== */
        .loading-state {
            text-align: center;
            padding: clamp(40px, 5vw, 80px) 20px;
            font-size: clamp(16px, 2vw, 20px);
            color: #666;
        }

        .loading-spinner {
            display: inline-block;
            margin-right: 10px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* ===== RESPONSIVE DESIGN ===== */
        @media (max-width: 992px) {
            .blog-details-wrapper {
                padding: 20px;
            }
        }

        @media (max-width: 768px) {
            .blog-featured-image {
                max-height: 350px;
            }

            .blog-meta {
                gap: 8px;
            }

            .blog-meta span {
                padding: 6px 12px;
                font-size: 12px;
            }

            .blog-post-content {
                padding: clamp(15px, 2vw, 25px);
            }
        }

        @media (max-width: 576px) {
            .blog-featured-image {
                max-height: 250px;
                border-radius: 12px;
            }

            .blog-post-header,
            .blog-post-content,
            .sidebar-widget {
                padding: clamp(15px, 2vw, 20px);
                border-radius: 12px;
            }

            .blog-post-header h1 {
                font-size: 22px;
            }

            .blog-meta {
                flex-direction: column;
                gap: 6px;
            }

            .blog-meta span {
                padding: 8px 12px;
                font-size: 11px;
            }

            .share-buttons {
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <!-- <div class="preloader">
        <button class="vs-btn preloaderCls">Cancel Preloader</button>
        <div class="preloader-inner">
            <img src="assets/img/logo.svg" alt="logo">
            <span class="loader"></span>
        </div>
    </div> -->

    <?php include 'header.php'; ?>

    <div class="breadcumb-wrapper " data-bg-src="assets/img/breadcumb/breadcumb-bg.png">
        <div class="container z-index-common">
            <div class="breadcumb-content">
                <h1 class="breadcumb-title">Blog Details</h1>
            </div>
            <div class="breadcumb-menu-wrap">
                <ul class="breadcumb-menu">
                    <li><a href="blog.php">Blog</a></li>
                    <li>Blog details</li>
                </ul>
            </div>
        </div>
    </div>

    <section class="blog-details-section space">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <article class="blog-post-full">
                        <div id="blogDetailsContainer" class="loading-state">
                            <i class="fas fa-spinner fa-spin loading-spinner"></i> Loading blog post...
                        </div>
                    </article>
                </div>
                <div class="col-lg-4">
                    <div class="sidebar" id="sidebarContainer">
                        <div class="sidebar-widget">
                            <h3><i class="fas fa-fire" style="color: #109C3D; margin-right: 8px;"></i>Recent Posts</h3>
                            <div id="recentPostsContainer">
                                <i class="fas fa-spinner fa-spin loading-spinner"></i> Loading...
                            </div>
                        </div>
                        <div class="author-card">
                            <h4>✨ About This Blog</h4>
                            <p>Stay updated with our latest cleaning tips, industry insights, and professional advice to keep your spaces spotless.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php include 'footer.php'; ?>

    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/gsap-scroll-to-plugin.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>

    <script>
        function getBlogIdFromURL() {
            const urlParams = new URLSearchParams(window.location.search);
            return urlParams.get('id');
        }

        function loadBlogDetails() {
            const blogId = getBlogIdFromURL();
            
            if (!blogId) {
                document.getElementById('blogDetailsContainer').innerHTML = '<p style="color: red;">Invalid blog ID</p>';
                return;
            }

            fetch(`api_handler.php?action=get_blog_details&id=${blogId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.success && data.data) {
                        renderBlogDetails(data.data);
                    } else {
                        document.getElementById('blogDetailsContainer').innerHTML = '<p style="color: red;">Blog not found</p>';
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    document.getElementById('blogDetailsContainer').innerHTML = '<p style="color: red;">Error loading blog post</p>';
                });
        }

        function renderBlogDetails(post) {
            const imageUrl = post.featured_image || 'assets/img/blog/blog-s-1-1.jpg';
            const createdDate = new Date(post.created_at).toLocaleDateString('en-US', {
                year: 'numeric',
                month: 'long',
                day: 'numeric'
            });
            const category = post.category || 'General';
            const readingTime = Math.ceil((post.content || '').split(' ').length / 200);

            let html = `
                <div class="blog-featured-image-wrapper">
                    <img class="blog-featured-image" src="${imageUrl}" alt="${post.title}" style="width: 100%; height: 100%; object-fit: cover;">
                </div>
                <div class="blog-post-header">
                    <h1>${post.title}</h1>
                    <div class="blog-meta">
                        <span><i class="fa-regular fa-calendar-days"></i> ${createdDate}</span>
                        <span><i class="fa-regular fa-folder"></i> ${category}</span>
                        <span><i class="fa-regular fa-clock"></i> ${readingTime} min read</span>
                        ${post.author_name ? `<span><i class="fa-regular fa-user"></i> ${post.author_name}</span>` : ''}
                    </div>
                </div>
                <div class="blog-post-content">
                    ${post.content || '<p>No content available</p>'}
                </div>
                <div class="author-card" style="margin-top: 30px;">
                    <h4>📌 Key Takeaways</h4>
                    <p>• Professional cleaning extends the life of your belongings</p>
                    <p>• Regular maintenance prevents costly repairs</p>
                    <p>• A clean space promotes better health and productivity</p>
                    <div class="share-buttons" style="margin-top: 15px;">
                        <button class="share-btn" title="Share on Facebook"><i class="fab fa-facebook-f"></i></button>
                        <button class="share-btn" title="Share on Twitter"><i class="fab fa-twitter"></i></button>
                        <button class="share-btn" title="Share on LinkedIn"><i class="fab fa-linkedin-in"></i></button>
                        <button class="share-btn" title="Copy Link"><i class="fas fa-link"></i></button>
                    </div>
                </div>
            `;

            document.getElementById('blogDetailsContainer').innerHTML = html;
            loadRecentPosts();
        }

        function loadRecentPosts() {
            fetch('api_handler.php?action=get_blog_posts')
                .then(response => response.json())
                .then(data => {
                    if (data.success && data.data) {
                        renderRecentPosts(data.data.slice(0, 5));
                    }
                })
                .catch(error => console.error('Error:', error));
        }

        function renderRecentPosts(posts) {
            let html = '<ul>';
            posts.forEach(post => {
                html += `<li><a href="blog-details.php?id=${post.id}">${post.title}</a></li>`;
            });
            html += '</ul>';
            document.getElementById('recentPostsContainer').innerHTML = html;
        }

        document.addEventListener('DOMContentLoaded', function() {
            loadBlogDetails();
        });
    </script>
</body>
</html>
